// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Permissions the identity has for keys, secrets, certificates and storage. */
@Fluent
public final class Permissions {
    /*
     * Permissions to keys
     */
    @JsonProperty(value = "keys")
    private List<KeyPermissions> keys;

    /*
     * Permissions to secrets
     */
    @JsonProperty(value = "secrets")
    private List<SecretPermissions> secrets;

    /*
     * Permissions to certificates
     */
    @JsonProperty(value = "certificates")
    private List<CertificatePermissions> certificates;

    /*
     * Permissions to storage accounts
     */
    @JsonProperty(value = "storage")
    private List<StoragePermissions> storage;

    /**
     * Get the keys property: Permissions to keys.
     *
     * @return the keys value.
     */
    public List<KeyPermissions> keys() {
        return this.keys;
    }

    /**
     * Set the keys property: Permissions to keys.
     *
     * @param keys the keys value to set.
     * @return the Permissions object itself.
     */
    public Permissions withKeys(List<KeyPermissions> keys) {
        this.keys = keys;
        return this;
    }

    /**
     * Get the secrets property: Permissions to secrets.
     *
     * @return the secrets value.
     */
    public List<SecretPermissions> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets property: Permissions to secrets.
     *
     * @param secrets the secrets value to set.
     * @return the Permissions object itself.
     */
    public Permissions withSecrets(List<SecretPermissions> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the certificates property: Permissions to certificates.
     *
     * @return the certificates value.
     */
    public List<CertificatePermissions> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: Permissions to certificates.
     *
     * @param certificates the certificates value to set.
     * @return the Permissions object itself.
     */
    public Permissions withCertificates(List<CertificatePermissions> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the storage property: Permissions to storage accounts.
     *
     * @return the storage value.
     */
    public List<StoragePermissions> storage() {
        return this.storage;
    }

    /**
     * Set the storage property: Permissions to storage accounts.
     *
     * @param storage the storage value to set.
     * @return the Permissions object itself.
     */
    public Permissions withStorage(List<StoragePermissions> storage) {
        this.storage = storage;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
