// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.keyvault.fluent.models.MhsmPrivateLinkResourceListResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in MhsmPrivateLinkResourcesClient. */
public interface MhsmPrivateLinkResourcesClient {
    /**
     * Gets the private link resources supported for the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources supported for the managed hsm pool along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MhsmPrivateLinkResourceListResultInner>> listByMhsmResourceWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Gets the private link resources supported for the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources supported for the managed hsm pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MhsmPrivateLinkResourceListResultInner> listByMhsmResourceAsync(String resourceGroupName, String name);

    /**
     * Gets the private link resources supported for the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources supported for the managed hsm pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MhsmPrivateLinkResourceListResultInner listByMhsmResource(String resourceGroupName, String name);

    /**
     * Gets the private link resources supported for the managed hsm pool.
     *
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @param name Name of the managed HSM Pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the private link resources supported for the managed hsm pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MhsmPrivateLinkResourceListResultInner> listByMhsmResourceWithResponse(
        String resourceGroupName, String name, Context context);
}
