// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsmResource;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Resource information with extended details. */
@Fluent
public final class ManagedHsmInner extends ManagedHsmResource {
    /*
     * Properties of the managed HSM
     */
    @JsonProperty(value = "properties")
    private ManagedHsmProperties properties;

    /** Creates an instance of ManagedHsmInner class. */
    public ManagedHsmInner() {
    }

    /**
     * Get the properties property: Properties of the managed HSM.
     *
     * @return the properties value.
     */
    public ManagedHsmProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the managed HSM.
     *
     * @param properties the properties value to set.
     * @return the ManagedHsmInner object itself.
     */
    public ManagedHsmInner withProperties(ManagedHsmProperties properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedHsmInner withSku(ManagedHsmSku sku) {
        super.withSku(sku);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedHsmInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedHsmInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
