// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Managed HSM resource. */
@Fluent
public class ManagedHsmResource extends Resource {
    /*
     * SKU details
     */
    @JsonProperty(value = "sku")
    private ManagedHsmSku sku;

    /*
     * Metadata pertaining to creation and last modification of the key vault resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of ManagedHsmResource class. */
    public ManagedHsmResource() {
    }

    /**
     * Get the sku property: SKU details.
     *
     * @return the sku value.
     */
    public ManagedHsmSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU details.
     *
     * @param sku the sku value to set.
     * @return the ManagedHsmResource object itself.
     */
    public ManagedHsmResource withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the key vault resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedHsmResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedHsmResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
    }
}
