/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.resourcemanager.keyvault.fluent.models.MhsmGeoReplicatedRegionInner;
import com.azure.resourcemanager.keyvault.models.CreateMode;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSecurityDomainProperties;
import com.azure.resourcemanager.keyvault.models.MhsmNetworkRuleSet;
import com.azure.resourcemanager.keyvault.models.MhsmPrivateEndpointConnectionItem;
import com.azure.resourcemanager.keyvault.models.ProvisioningState;
import com.azure.resourcemanager.keyvault.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class ManagedHsmProperties {
    @JsonProperty(value="tenantId")
    private UUID tenantId;
    @JsonProperty(value="initialAdminObjectIds")
    private List<String> initialAdminObjectIds;
    @JsonProperty(value="hsmUri", access=JsonProperty.Access.WRITE_ONLY)
    private String hsmUri;
    @JsonProperty(value="enableSoftDelete")
    private Boolean enableSoftDelete;
    @JsonProperty(value="softDeleteRetentionInDays")
    private Integer softDeleteRetentionInDays;
    @JsonProperty(value="enablePurgeProtection")
    private Boolean enablePurgeProtection;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    @JsonProperty(value="statusMessage", access=JsonProperty.Access.WRITE_ONLY)
    private String statusMessage;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="networkAcls")
    private MhsmNetworkRuleSet networkAcls;
    @JsonProperty(value="regions")
    private List<MhsmGeoReplicatedRegionInner> regions;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<MhsmPrivateEndpointConnectionItem> privateEndpointConnections;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="scheduledPurgeDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime scheduledPurgeDate;
    @JsonProperty(value="securityDomainProperties", access=JsonProperty.Access.WRITE_ONLY)
    private ManagedHsmSecurityDomainProperties securityDomainProperties;

    public UUID tenantId() {
        return this.tenantId;
    }

    public ManagedHsmProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public List<String> initialAdminObjectIds() {
        return this.initialAdminObjectIds;
    }

    public ManagedHsmProperties withInitialAdminObjectIds(List<String> initialAdminObjectIds) {
        this.initialAdminObjectIds = initialAdminObjectIds;
        return this;
    }

    public String hsmUri() {
        return this.hsmUri;
    }

    public Boolean enableSoftDelete() {
        return this.enableSoftDelete;
    }

    public ManagedHsmProperties withEnableSoftDelete(Boolean enableSoftDelete) {
        this.enableSoftDelete = enableSoftDelete;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public ManagedHsmProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public ManagedHsmProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ManagedHsmProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public MhsmNetworkRuleSet networkAcls() {
        return this.networkAcls;
    }

    public ManagedHsmProperties withNetworkAcls(MhsmNetworkRuleSet networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    public List<MhsmGeoReplicatedRegionInner> regions() {
        return this.regions;
    }

    public ManagedHsmProperties withRegions(List<MhsmGeoReplicatedRegionInner> regions) {
        this.regions = regions;
        return this;
    }

    public List<MhsmPrivateEndpointConnectionItem> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ManagedHsmProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public ManagedHsmSecurityDomainProperties securityDomainProperties() {
        return this.securityDomainProperties;
    }

    public void validate() {
        if (this.networkAcls() != null) {
            this.networkAcls().validate();
        }
        if (this.regions() != null) {
            this.regions().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.securityDomainProperties() != null) {
            this.securityDomainProperties().validate();
        }
    }
}

