// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The parameters used to check the availability of the managed hsm name. */
@Fluent
public final class CheckMhsmNameAvailabilityParameters {
    /*
     * The managed hsm name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /** Creates an instance of CheckMhsmNameAvailabilityParameters class. */
    public CheckMhsmNameAvailabilityParameters() {
    }

    /**
     * Get the name property: The managed hsm name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The managed hsm name.
     *
     * @param name the name value to set.
     * @return the CheckMhsmNameAvailabilityParameters object itself.
     */
    public CheckMhsmNameAvailabilityParameters withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property name in model CheckMhsmNameAvailabilityParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CheckMhsmNameAvailabilityParameters.class);
}
