// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** SKU details. */
@Fluent
public final class ManagedHsmSku {
    /*
     * SKU Family of the managed HSM Pool
     */
    @JsonProperty(value = "family", required = true)
    private ManagedHsmSkuFamily family = ManagedHsmSkuFamily.B;

    /*
     * SKU of the managed HSM Pool
     */
    @JsonProperty(value = "name", required = true)
    private ManagedHsmSkuName name;

    /** Creates an instance of ManagedHsmSku class. */
    public ManagedHsmSku() {
    }

    /**
     * Get the family property: SKU Family of the managed HSM Pool.
     *
     * @return the family value.
     */
    public ManagedHsmSkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: SKU Family of the managed HSM Pool.
     *
     * @param family the family value to set.
     * @return the ManagedHsmSku object itself.
     */
    public ManagedHsmSku withFamily(ManagedHsmSkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Get the name property: SKU of the managed HSM Pool.
     *
     * @return the name value.
     */
    public ManagedHsmSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: SKU of the managed HSM Pool.
     *
     * @param name the name value to set.
     * @return the ManagedHsmSku object itself.
     */
    public ManagedHsmSku withName(ManagedHsmSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (family() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property family in model ManagedHsmSku"));
        }
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model ManagedHsmSku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmSku.class);
}
