// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** SKU details. */
@Fluent
public final class Sku {
    /*
     * SKU family name
     */
    @JsonProperty(value = "family", required = true)
    private SkuFamily family = SkuFamily.A;

    /*
     * SKU name to specify whether the key vault is a standard vault or a premium vault.
     */
    @JsonProperty(value = "name", required = true)
    private SkuName name;

    /** Creates an instance of Sku class. */
    public Sku() {
    }

    /**
     * Get the family property: SKU family name.
     *
     * @return the family value.
     */
    public SkuFamily family() {
        return this.family;
    }

    /**
     * Set the family property: SKU family name.
     *
     * @param family the family value to set.
     * @return the Sku object itself.
     */
    public Sku withFamily(SkuFamily family) {
        this.family = family;
        return this;
    }

    /**
     * Get the name property: SKU name to specify whether the key vault is a standard vault or a premium vault.
     *
     * @return the name value.
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set the name property: SKU name to specify whether the key vault is a standard vault or a premium vault.
     *
     * @param name the name value to set.
     * @return the Sku object itself.
     */
    public Sku withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (family() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property family in model Sku"));
        }
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);
}
