// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass
 * property has been evaluated.
 */
public final class NetworkRuleAction extends ExpandableStringEnum<NetworkRuleAction> {
    /**
     * Static value Allow for NetworkRuleAction.
     */
    public static final NetworkRuleAction ALLOW = fromString("Allow");

    /**
     * Static value Deny for NetworkRuleAction.
     */
    public static final NetworkRuleAction DENY = fromString("Deny");

    /**
     * Creates a new instance of NetworkRuleAction value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkRuleAction() {
    }

    /**
     * Creates or finds a NetworkRuleAction from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkRuleAction.
     */
    public static NetworkRuleAction fromString(String name) {
        return fromString(name, NetworkRuleAction.class);
    }

    /**
     * Gets known NetworkRuleAction values.
     * 
     * @return known NetworkRuleAction values.
     */
    public static Collection<NetworkRuleAction> values() {
        return values(NetworkRuleAction.class);
    }
}
