/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import java.io.IOException;
import java.util.List;

public final class VaultAccessPolicyProperties
implements JsonSerializable<VaultAccessPolicyProperties> {
    private List<AccessPolicyEntry> accessPolicies;
    private static final ClientLogger LOGGER = new ClientLogger(VaultAccessPolicyProperties.class);

    public List<AccessPolicyEntry> accessPolicies() {
        return this.accessPolicies;
    }

    public VaultAccessPolicyProperties withAccessPolicies(List<AccessPolicyEntry> accessPolicies) {
        this.accessPolicies = accessPolicies;
        return this;
    }

    public void validate() {
        if (this.accessPolicies() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessPolicies in model VaultAccessPolicyProperties"));
        }
        this.accessPolicies().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("accessPolicies", this.accessPolicies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VaultAccessPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VaultAccessPolicyProperties)jsonReader.readObject(reader -> {
            VaultAccessPolicyProperties deserializedVaultAccessPolicyProperties = new VaultAccessPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessPolicies".equals(fieldName)) {
                    List accessPolicies;
                    deserializedVaultAccessPolicyProperties.accessPolicies = accessPolicies = reader.readArray(reader1 -> AccessPolicyEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultAccessPolicyProperties;
        });
    }
}

