/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSku;
import com.azure.resourcemanager.keyvault.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public class ManagedHsmResource
extends Resource {
    private ManagedHsmSku sku;
    private SystemData systemData;
    private ManagedServiceIdentity identity;
    private String id;
    private String name;
    private String type;

    public ManagedHsmSku sku() {
        return this.sku;
    }

    public ManagedHsmResource withSku(ManagedHsmSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    ManagedHsmResource withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ManagedHsmResource withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ManagedHsmResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedHsmResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmResource fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmResource)((Object)jsonReader.readObject(reader -> {
            ManagedHsmResource deserializedManagedHsmResource = new ManagedHsmResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedHsmResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedHsmResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedHsmResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedHsmResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmResource.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedManagedHsmResource.sku = ManagedHsmSku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedHsmResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedManagedHsmResource.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmResource;
        }));
    }
}

