/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSkuFamily;
import com.azure.resourcemanager.keyvault.models.ManagedHsmSkuName;
import java.io.IOException;

public final class ManagedHsmSku
implements JsonSerializable<ManagedHsmSku> {
    private ManagedHsmSkuFamily family = ManagedHsmSkuFamily.B;
    private ManagedHsmSkuName name;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmSku.class);

    public ManagedHsmSkuFamily family() {
        return this.family;
    }

    public ManagedHsmSku withFamily(ManagedHsmSkuFamily family) {
        this.family = family;
        return this;
    }

    public ManagedHsmSkuName name() {
        return this.name;
    }

    public ManagedHsmSku withName(ManagedHsmSkuName name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.family() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property family in model ManagedHsmSku"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagedHsmSku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("family", this.family == null ? null : this.family.toString());
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmSku fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmSku)jsonReader.readObject(reader -> {
            ManagedHsmSku deserializedManagedHsmSku = new ManagedHsmSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("family".equals(fieldName)) {
                    deserializedManagedHsmSku.family = ManagedHsmSkuFamily.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedHsmSku.name = ManagedHsmSkuName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmSku;
        });
    }
}

