/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.CertificatePermissions;
import com.azure.resourcemanager.keyvault.models.KeyPermissions;
import com.azure.resourcemanager.keyvault.models.SecretPermissions;
import com.azure.resourcemanager.keyvault.models.StoragePermissions;
import java.io.IOException;
import java.util.List;

public final class Permissions
implements JsonSerializable<Permissions> {
    private List<KeyPermissions> keys;
    private List<SecretPermissions> secrets;
    private List<CertificatePermissions> certificates;
    private List<StoragePermissions> storage;

    public List<KeyPermissions> keys() {
        return this.keys;
    }

    public Permissions withKeys(List<KeyPermissions> keys) {
        this.keys = keys;
        return this;
    }

    public List<SecretPermissions> secrets() {
        return this.secrets;
    }

    public Permissions withSecrets(List<SecretPermissions> secrets) {
        this.secrets = secrets;
        return this;
    }

    public List<CertificatePermissions> certificates() {
        return this.certificates;
    }

    public Permissions withCertificates(List<CertificatePermissions> certificates) {
        this.certificates = certificates;
        return this;
    }

    public List<StoragePermissions> storage() {
        return this.storage;
    }

    public Permissions withStorage(List<StoragePermissions> storage) {
        this.storage = storage;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("keys", this.keys, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("storage", this.storage, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static Permissions fromJson(JsonReader jsonReader) throws IOException {
        return (Permissions)jsonReader.readObject(reader -> {
            Permissions deserializedPermissions = new Permissions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keys".equals(fieldName)) {
                    List keys;
                    deserializedPermissions.keys = keys = reader.readArray(reader1 -> KeyPermissions.fromString(reader1.getString()));
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedPermissions.secrets = secrets = reader.readArray(reader1 -> SecretPermissions.fromString(reader1.getString()));
                    continue;
                }
                if ("certificates".equals(fieldName)) {
                    List certificates;
                    deserializedPermissions.certificates = certificates = reader.readArray(reader1 -> CertificatePermissions.fromString(reader1.getString()));
                    continue;
                }
                if ("storage".equals(fieldName)) {
                    List storage;
                    deserializedPermissions.storage = storage = reader.readArray(reader1 -> StoragePermissions.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPermissions;
        });
    }
}

