/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretAttributes;
import java.io.IOException;

public final class SecretPatchProperties
implements JsonSerializable<SecretPatchProperties> {
    private String value;
    private String contentType;
    private SecretAttributes attributes;

    public String value() {
        return this.value;
    }

    public SecretPatchProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public SecretPatchProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SecretAttributes attributes() {
        return this.attributes;
    }

    public SecretPatchProperties withAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static SecretPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecretPatchProperties)jsonReader.readObject(reader -> {
            SecretPatchProperties deserializedSecretPatchProperties = new SecretPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretPatchProperties.value = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretPatchProperties.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretPatchProperties.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretPatchProperties;
        });
    }
}

