/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretAttributes;
import java.io.IOException;

public final class SecretProperties
implements JsonSerializable<SecretProperties> {
    private String value;
    private String contentType;
    private SecretAttributes attributes;
    private String secretUri;
    private String secretUriWithVersion;

    public String value() {
        return this.value;
    }

    public SecretProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public SecretProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SecretAttributes attributes() {
        return this.attributes;
    }

    public SecretProperties withAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public String secretUri() {
        return this.secretUri;
    }

    public String secretUriWithVersion() {
        return this.secretUriWithVersion;
    }

    public void validate() {
        if (this.attributes() != null) {
            this.attributes().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static SecretProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecretProperties)jsonReader.readObject(reader -> {
            SecretProperties deserializedSecretProperties = new SecretProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretProperties.value = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretProperties.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretProperties.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("secretUri".equals(fieldName)) {
                    deserializedSecretProperties.secretUri = reader.getString();
                    continue;
                }
                if ("secretUriWithVersion".equals(fieldName)) {
                    deserializedSecretProperties.secretUriWithVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretProperties;
        });
    }
}

