// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.keyvault.fluent.KeysClient;
import com.azure.resourcemanager.keyvault.fluent.models.KeyInner;
import com.azure.resourcemanager.keyvault.models.KeyCreateParameters;
import com.azure.resourcemanager.keyvault.models.KeyListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in KeysClient.
 */
public final class KeysClientImpl implements KeysClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final KeysService service;

    /**
     * The service client containing this operation class.
     */
    private final KeyVaultManagementClientImpl client;

    /**
     * Initializes an instance of KeysClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    KeysClientImpl(KeyVaultManagementClientImpl client) {
        this.service = RestProxy.create(KeysService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for KeyVaultManagementClientKeys to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "KeyVaultManagementCl")
    public interface KeysService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyInner>> createIfNotExist(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vaultName") String vaultName,
            @PathParam("keyName") String keyName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") KeyCreateParameters parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vaultName") String vaultName,
            @PathParam("keyName") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vaultName") String vaultName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}/versions/{keyVersion}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyInner>> getVersion(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vaultName") String vaultName,
            @PathParam("keyName") String keyName, @PathParam("keyVersion") String keyVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyListResult>> listVersions(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("vaultName") String vaultName,
            @PathParam("keyName") String keyName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<KeyListResult>> listVersionsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the key vault which contains the key to be created.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String vaultName,
        String keyName, KeyCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createIfNotExist(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, vaultName, keyName, this.client.getApiVersion(), parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the key vault which contains the key to be created.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<KeyInner>> createIfNotExistWithResponseAsync(String resourceGroupName, String vaultName,
        String keyName, KeyCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createIfNotExist(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            vaultName, keyName, this.client.getApiVersion(), parameters, accept, context);
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the key vault which contains the key to be created.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyInner> createIfNotExistAsync(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters) {
        return createIfNotExistWithResponseAsync(resourceGroupName, vaultName, keyName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the key vault which contains the key to be created.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyInner> createIfNotExistWithResponse(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters, Context context) {
        return createIfNotExistWithResponseAsync(resourceGroupName, vaultName, keyName, parameters, context).block();
    }

    /**
     * Creates the first version of a new key if it does not exist. If it already exists, then the existing key is
     * returned without any write operations being performed. This API does not create subsequent versions, and does not
     * update existing keys.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the key vault which contains the key to be created.
     * @param keyName The name of the key to be created. The value you provide may be copied globally for the purpose of
     * running the service. The value provided should not include personally identifiable or sensitive information.
     * @param parameters The parameters used to create the specified key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the key resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyInner createIfNotExist(String resourceGroupName, String vaultName, String keyName,
        KeyCreateParameters parameters) {
        return createIfNotExistWithResponse(resourceGroupName, vaultName, keyName, parameters, Context.NONE).getValue();
    }

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, vaultName, keyName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<KeyInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String keyName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName,
            keyName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyInner> getAsync(String resourceGroupName, String vaultName, String keyName) {
        return getWithResponseAsync(resourceGroupName, vaultName, keyName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyInner> getWithResponse(String resourceGroupName, String vaultName, String keyName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, vaultName, keyName, context).block();
    }

    /**
     * Gets the current version of the specified key from the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @param keyName The name of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current version of the specified key from the specified key vault.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyInner get(String resourceGroupName, String vaultName, String keyName) {
        return getWithResponse(resourceGroupName, vaultName, keyName, Context.NONE).getValue();
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listSinglePageAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, vaultName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<KeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listSinglePageAsync(String resourceGroupName, String vaultName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyInner> listAsync(String resourceGroupName, String vaultName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, vaultName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<KeyInner> listAsync(String resourceGroupName, String vaultName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, vaultName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyInner> list(String resourceGroupName, String vaultName) {
        return new PagedIterable<>(listAsync(resourceGroupName, vaultName));
    }

    /**
     * Lists the keys in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the keys to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyInner> list(String resourceGroupName, String vaultName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, vaultName, context));
    }

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KeyInner>> getVersionWithResponseAsync(String resourceGroupName, String vaultName,
        String keyName, String keyVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (keyVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getVersion(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, vaultName, keyName, keyVersion, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<KeyInner>> getVersionWithResponseAsync(String resourceGroupName, String vaultName,
        String keyName, String keyVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (keyVersion == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyVersion is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getVersion(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            vaultName, keyName, keyVersion, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KeyInner> getVersionAsync(String resourceGroupName, String vaultName, String keyName,
        String keyVersion) {
        return getVersionWithResponseAsync(resourceGroupName, vaultName, keyName, keyVersion)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KeyInner> getVersionWithResponse(String resourceGroupName, String vaultName, String keyName,
        String keyVersion, Context context) {
        return getVersionWithResponseAsync(resourceGroupName, vaultName, keyName, keyVersion, context).block();
    }

    /**
     * Gets the specified version of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key version to be retrieved.
     * @param keyName The name of the key version to be retrieved.
     * @param keyVersion The version of the key to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified version of the specified key in the specified key vault.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KeyInner getVersion(String resourceGroupName, String vaultName, String keyName, String keyVersion) {
        return getVersionWithResponse(resourceGroupName, vaultName, keyName, keyVersion, Context.NONE).getValue();
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listVersionsSinglePageAsync(String resourceGroupName, String vaultName,
        String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVersions(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, vaultName, keyName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<KeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listVersionsSinglePageAsync(String resourceGroupName, String vaultName,
        String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error(new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listVersions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName,
                keyName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<KeyInner> listVersionsAsync(String resourceGroupName, String vaultName, String keyName) {
        return new PagedFlux<>(() -> listVersionsSinglePageAsync(resourceGroupName, vaultName, keyName),
            nextLink -> listVersionsNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<KeyInner> listVersionsAsync(String resourceGroupName, String vaultName, String keyName,
        Context context) {
        return new PagedFlux<>(() -> listVersionsSinglePageAsync(resourceGroupName, vaultName, keyName, context),
            nextLink -> listVersionsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyInner> listVersions(String resourceGroupName, String vaultName, String keyName) {
        return new PagedIterable<>(listVersionsAsync(resourceGroupName, vaultName, keyName));
    }

    /**
     * Lists the versions of the specified key in the specified key vault.
     * 
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key versions to be retrieved.
     * @param keyName The name of the key versions to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<KeyInner> listVersions(String resourceGroupName, String vaultName, String keyName,
        Context context) {
        return new PagedIterable<>(listVersionsAsync(resourceGroupName, vaultName, keyName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<KeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listVersionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVersionsNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<KeyInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the page of keys along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<KeyInner>> listVersionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listVersionsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
