// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Properties of the deleted vault.
 */
@Immutable
public final class DeletedVaultProperties implements JsonSerializable<DeletedVaultProperties> {
    /*
     * The resource id of the original vault.
     */
    private String vaultId;

    /*
     * The location of the original vault.
     */
    private String location;

    /*
     * The deleted date.
     */
    private OffsetDateTime deletionDate;

    /*
     * The scheduled purged date.
     */
    private OffsetDateTime scheduledPurgeDate;

    /*
     * Tags of the original vault.
     */
    private Map<String, String> tags;

    /*
     * Purge protection status of the original vault.
     */
    private Boolean purgeProtectionEnabled;

    /**
     * Creates an instance of DeletedVaultProperties class.
     */
    public DeletedVaultProperties() {
    }

    /**
     * Get the vaultId property: The resource id of the original vault.
     * 
     * @return the vaultId value.
     */
    public String vaultId() {
        return this.vaultId;
    }

    /**
     * Get the location property: The location of the original vault.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the deletionDate property: The deleted date.
     * 
     * @return the deletionDate value.
     */
    public OffsetDateTime deletionDate() {
        return this.deletionDate;
    }

    /**
     * Get the scheduledPurgeDate property: The scheduled purged date.
     * 
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime scheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    /**
     * Get the tags property: Tags of the original vault.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Get the purgeProtectionEnabled property: Purge protection status of the original vault.
     * 
     * @return the purgeProtectionEnabled value.
     */
    public Boolean purgeProtectionEnabled() {
        return this.purgeProtectionEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedVaultProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedVaultProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedVaultProperties.
     */
    public static DeletedVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedVaultProperties deserializedDeletedVaultProperties = new DeletedVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vaultId".equals(fieldName)) {
                    deserializedDeletedVaultProperties.vaultId = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDeletedVaultProperties.location = reader.getString();
                } else if ("deletionDate".equals(fieldName)) {
                    deserializedDeletedVaultProperties.deletionDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedVaultProperties.scheduledPurgeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedVaultProperties.tags = tags;
                } else if ("purgeProtectionEnabled".equals(fieldName)) {
                    deserializedDeletedVaultProperties.purgeProtectionEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedVaultProperties;
        });
    }
}
