/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.SecretProperties;
import java.io.IOException;
import java.util.Map;

public final class SecretInner
extends Resource {
    private SecretProperties properties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SecretInner.class);

    public SecretProperties properties() {
        return this.properties;
    }

    public SecretInner withProperties(SecretProperties properties) {
        this.properties = properties;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SecretInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SecretInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model SecretInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static SecretInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecretInner)((Object)jsonReader.readObject(reader -> {
            SecretInner deserializedSecretInner = new SecretInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecretInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecretInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSecretInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecretInner.properties = SecretProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretInner;
        }));
    }
}

