// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key
 * vault's tenant ID.
 */
@Fluent
public final class AccessPolicyEntry implements JsonSerializable<AccessPolicyEntry> {
    /*
     * The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
     */
    private UUID tenantId;

    /*
     * The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault.
     * The object ID must be unique for the list of access policies.
     */
    private String objectId;

    /*
     * Application ID of the client making request on behalf of a principal
     */
    private UUID applicationId;

    /*
     * Permissions the identity has for keys, secrets and certificates.
     */
    private Permissions permissions;

    /**
     * Creates an instance of AccessPolicyEntry class.
     */
    public AccessPolicyEntry() {
    }

    /**
     * Get the tenantId property: The Azure Active Directory tenant ID that should be used for authenticating requests
     * to the key vault.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The Azure Active Directory tenant ID that should be used for authenticating requests
     * to the key vault.
     * 
     * @param tenantId the tenantId value to set.
     * @return the AccessPolicyEntry object itself.
     */
    public AccessPolicyEntry withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the objectId property: The object ID of a user, service principal or security group in the Azure Active
     * Directory tenant for the vault. The object ID must be unique for the list of access policies.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: The object ID of a user, service principal or security group in the Azure Active
     * Directory tenant for the vault. The object ID must be unique for the list of access policies.
     * 
     * @param objectId the objectId value to set.
     * @return the AccessPolicyEntry object itself.
     */
    public AccessPolicyEntry withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Get the applicationId property: Application ID of the client making request on behalf of a principal.
     * 
     * @return the applicationId value.
     */
    public UUID applicationId() {
        return this.applicationId;
    }

    /**
     * Set the applicationId property: Application ID of the client making request on behalf of a principal.
     * 
     * @param applicationId the applicationId value to set.
     * @return the AccessPolicyEntry object itself.
     */
    public AccessPolicyEntry withApplicationId(UUID applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Get the permissions property: Permissions the identity has for keys, secrets and certificates.
     * 
     * @return the permissions value.
     */
    public Permissions permissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: Permissions the identity has for keys, secrets and certificates.
     * 
     * @param permissions the permissions value to set.
     * @return the AccessPolicyEntry object itself.
     */
    public AccessPolicyEntry withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tenantId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property tenantId in model AccessPolicyEntry"));
        }
        if (objectId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property objectId in model AccessPolicyEntry"));
        }
        if (permissions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property permissions in model AccessPolicyEntry"));
        } else {
            permissions().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AccessPolicyEntry.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("objectId", this.objectId);
        jsonWriter.writeJsonField("permissions", this.permissions);
        jsonWriter.writeStringField("applicationId", Objects.toString(this.applicationId, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessPolicyEntry from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessPolicyEntry if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AccessPolicyEntry.
     */
    public static AccessPolicyEntry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessPolicyEntry deserializedAccessPolicyEntry = new AccessPolicyEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.tenantId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("objectId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.objectId = reader.getString();
                } else if ("permissions".equals(fieldName)) {
                    deserializedAccessPolicyEntry.permissions = Permissions.fromJson(reader);
                } else if ("applicationId".equals(fieldName)) {
                    deserializedAccessPolicyEntry.applicationId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessPolicyEntry;
        });
    }
}
