/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.management.exception.AdditionalInfo;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class Error
extends ManagementError {
    private Error innerError;
    private List<AdditionalInfo> additionalInfo;
    private List<ManagementError> details;
    private String target;
    private String message;
    private String code;

    public Error getInnerError() {
        return this.innerError;
    }

    public List<AdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public List<ManagementError> getDetails() {
        return this.details;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public void validate() {
        if (this.getInnerError() != null) {
            this.getInnerError().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return (Error)((Object)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return Error.readManagementError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return Error.readManagementError(bufferedReader.reset());
        }));
    }

    private static Error readManagementError(JsonReader jsonReader) throws IOException {
        return (Error)((Object)jsonReader.readObject(reader -> {
            Error deserializedError = new Error();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedError.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedError.details = details = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedError.additionalInfo = additionalInfo = reader.readArray(reader1 -> AdditionalInfo.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    deserializedError.innerError = Error.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedError;
        }));
    }
}

