// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The elliptic curve name. For valid values, see JsonWebKeyCurveName. Default for EC and EC-HSM keys is P-256.
 */
public final class JsonWebKeyCurveName extends ExpandableStringEnum<JsonWebKeyCurveName> {
    /**
     * Static value P-256 for JsonWebKeyCurveName.
     */
    public static final JsonWebKeyCurveName P_256 = fromString("P-256");

    /**
     * Static value P-384 for JsonWebKeyCurveName.
     */
    public static final JsonWebKeyCurveName P_384 = fromString("P-384");

    /**
     * Static value P-521 for JsonWebKeyCurveName.
     */
    public static final JsonWebKeyCurveName P_521 = fromString("P-521");

    /**
     * Static value P-256K for JsonWebKeyCurveName.
     */
    public static final JsonWebKeyCurveName P_256K = fromString("P-256K");

    /**
     * Creates a new instance of JsonWebKeyCurveName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public JsonWebKeyCurveName() {
    }

    /**
     * Creates or finds a JsonWebKeyCurveName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding JsonWebKeyCurveName.
     */
    public static JsonWebKeyCurveName fromString(String name) {
        return fromString(name, JsonWebKeyCurveName.class);
    }

    /**
     * Gets known JsonWebKeyCurveName values.
     * 
     * @return known JsonWebKeyCurveName values.
     */
    public static Collection<JsonWebKeyCurveName> values() {
        return values(JsonWebKeyCurveName.class);
    }
}
