// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyInner;
import java.io.IOException;
import java.util.List;

/**
 * The page of keys.
 */
@Fluent
public final class ManagedHsmKeyListResult implements JsonSerializable<ManagedHsmKeyListResult> {
    /*
     * The key resources.
     */
    private List<ManagedHsmKeyInner> value;

    /*
     * The URL to get the next page of keys.
     */
    private String nextLink;

    /**
     * Creates an instance of ManagedHsmKeyListResult class.
     */
    public ManagedHsmKeyListResult() {
    }

    /**
     * Get the value property: The key resources.
     * 
     * @return the value value.
     */
    public List<ManagedHsmKeyInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The key resources.
     * 
     * @param value the value value to set.
     * @return the ManagedHsmKeyListResult object itself.
     */
    public ManagedHsmKeyListResult withValue(List<ManagedHsmKeyInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next page of keys.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next page of keys.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ManagedHsmKeyListResult object itself.
     */
    public ManagedHsmKeyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedHsmKeyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedHsmKeyListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedHsmKeyListResult.
     */
    public static ManagedHsmKeyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedHsmKeyListResult deserializedManagedHsmKeyListResult = new ManagedHsmKeyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ManagedHsmKeyInner> value = reader.readArray(reader1 -> ManagedHsmKeyInner.fromJson(reader1));
                    deserializedManagedHsmKeyListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedManagedHsmKeyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedHsmKeyListResult;
        });
    }
}
