// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * List of vault resources.
 */
@Fluent
public final class ResourceListResult implements JsonSerializable<ResourceListResult> {
    /*
     * The list of vault resources.
     */
    private List<Resource> value;

    /*
     * The URL to get the next set of vault resources.
     */
    private String nextLink;

    /**
     * Creates an instance of ResourceListResult class.
     */
    public ResourceListResult() {
    }

    /**
     * Get the value property: The list of vault resources.
     * 
     * @return the value value.
     */
    public List<Resource> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of vault resources.
     * 
     * @param value the value value to set.
     * @return the ResourceListResult object itself.
     */
    public ResourceListResult withValue(List<Resource> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of vault resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of vault resources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ResourceListResult object itself.
     */
    public ResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceListResult.
     */
    public static ResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceListResult deserializedResourceListResult = new ResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<Resource> value = reader.readArray(reader1 -> Resource.fromJson(reader1));
                    deserializedResourceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedResourceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceListResult;
        });
    }
}
