/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.PrivateEndpoint;
import com.azure.resourcemanager.keyvault.models.PrivateEndpointConnectionProvisioningState;
import com.azure.resourcemanager.keyvault.models.PrivateLinkServiceConnectionState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class PrivateEndpointConnectionItem {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointConnectionItem.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="properties.privateEndpoint")
    private PrivateEndpoint privateEndpoint;
    @JsonProperty(value="properties.privateLinkServiceConnectionState")
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private PrivateEndpointConnectionProvisioningState provisioningState;

    public String id() {
        return this.id;
    }

    public PrivateEndpointConnectionItem withId(String id) {
        this.id = id;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public PrivateEndpointConnectionItem withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public PrivateEndpoint privateEndpoint() {
        return this.privateEndpoint;
    }

    public PrivateEndpointConnectionItem withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateEndpointConnectionItem withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateEndpointConnectionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }
}

