// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackQueryInner;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties;

/** An instance of this class provides access to all the operations defined in QueriesClient. */
public interface QueriesClient {
    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LogAnalyticsQueryPackQueryInner> list(String resourceGroupName, String queryPackName);

    /**
     * Gets a list of Queries defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     *     return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Queries defined within a Log Analytics QueryPack as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LogAnalyticsQueryPackQueryInner> list(
        String resourceGroupName,
        String queryPackName,
        Long top,
        Boolean includeBody,
        String skipToken,
        Context context);

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LogAnalyticsQueryPackQueryInner> search(
        String resourceGroupName,
        String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties);

    /**
     * Search a list of Queries defined within a Log Analytics QueryPack according to given search properties.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param querySearchProperties Properties by which to search queries in the given Log Analytics QueryPack.
     * @param top Maximum items returned in page.
     * @param includeBody Flag indicating whether or not to return the body of each applicable query. If false, only
     *     return the query information.
     * @param skipToken Base64 encoded token used to fetch the next page of items. Default is null.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes the list of Log Analytics QueryPack-Query resources as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LogAnalyticsQueryPackQueryInner> search(
        String resourceGroupName,
        String queryPackName,
        LogAnalyticsQueryPackQuerySearchProperties querySearchProperties,
        Long top,
        Boolean includeBody,
        String skipToken,
        Context context);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LogAnalyticsQueryPackQueryInner get(String resourceGroupName, String queryPackName, String id);

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Log Analytics Query defined within a Log Analytics QueryPack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LogAnalyticsQueryPackQueryInner> getWithResponse(
        String resourceGroupName, String queryPackName, String id, Context context);

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     *     QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LogAnalyticsQueryPackQueryInner put(
        String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload);

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     *     QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LogAnalyticsQueryPackQueryInner> putWithResponse(
        String resourceGroupName,
        String queryPackName,
        String id,
        LogAnalyticsQueryPackQueryInner queryPayload,
        Context context);

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     *     QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LogAnalyticsQueryPackQueryInner update(
        String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload);

    /**
     * Adds or Updates a specific Query within a Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param queryPayload Properties that need to be specified to create a new query and add it to a Log Analytics
     *     QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Log Analytics QueryPack-Query definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LogAnalyticsQueryPackQueryInner> updateWithResponse(
        String resourceGroupName,
        String queryPackName,
        String id,
        LogAnalyticsQueryPackQueryInner queryPayload,
        Context context);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String queryPackName, String id);

    /**
     * Deletes a specific Query defined within an Log Analytics QueryPack.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param id The id of a specific query defined in the Log Analytics QueryPack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String queryPackName, String id, Context context);
}
