// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.SharedKeysInner;

/** An instance of this class provides access to all the operations defined in SharedKeysOperationsClient. */
public interface SharedKeysOperationsClient {
    /**
     * Gets the shared keys for a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SharedKeysInner getSharedKeys(String resourceGroupName, String workspaceName);

    /**
     * Gets the shared keys for a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SharedKeysInner> getSharedKeysWithResponse(
        String resourceGroupName, String workspaceName, Context context);

    /**
     * Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational
     * Insights agents to the workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SharedKeysInner regenerate(String resourceGroupName, String workspaceName);

    /**
     * Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational
     * Insights agents to the workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the shared keys for a workspace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SharedKeysInner> regenerateWithResponse(String resourceGroupName, String workspaceName, Context context);
}
