// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.loganalytics.models.SkuNameEnum;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Service Tier details. */
@Immutable
public final class AvailableServiceTierInner {
    /*
     * The name of the Service Tier.
     */
    @JsonProperty(value = "serviceTier", access = JsonProperty.Access.WRITE_ONLY)
    private SkuNameEnum serviceTier;

    /*
     * True if the Service Tier is enabled for the workspace.
     */
    @JsonProperty(value = "enabled", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean enabled;

    /*
     * The minimum retention for the Service Tier, in days.
     */
    @JsonProperty(value = "minimumRetention", access = JsonProperty.Access.WRITE_ONLY)
    private Long minimumRetention;

    /*
     * The maximum retention for the Service Tier, in days.
     */
    @JsonProperty(value = "maximumRetention", access = JsonProperty.Access.WRITE_ONLY)
    private Long maximumRetention;

    /*
     * The default retention for the Service Tier, in days.
     */
    @JsonProperty(value = "defaultRetention", access = JsonProperty.Access.WRITE_ONLY)
    private Long defaultRetention;

    /*
     * The capacity reservation level in GB per day. Returned for the Capacity
     * Reservation Service Tier.
     */
    @JsonProperty(value = "capacityReservationLevel", access = JsonProperty.Access.WRITE_ONLY)
    private Long capacityReservationLevel;

    /*
     * Time when the sku was last updated for the workspace. Returned for the
     * Capacity Reservation Service Tier.
     */
    @JsonProperty(value = "lastSkuUpdate", access = JsonProperty.Access.WRITE_ONLY)
    private String lastSkuUpdate;

    /**
     * Get the serviceTier property: The name of the Service Tier.
     *
     * @return the serviceTier value.
     */
    public SkuNameEnum serviceTier() {
        return this.serviceTier;
    }

    /**
     * Get the enabled property: True if the Service Tier is enabled for the workspace.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Get the minimumRetention property: The minimum retention for the Service Tier, in days.
     *
     * @return the minimumRetention value.
     */
    public Long minimumRetention() {
        return this.minimumRetention;
    }

    /**
     * Get the maximumRetention property: The maximum retention for the Service Tier, in days.
     *
     * @return the maximumRetention value.
     */
    public Long maximumRetention() {
        return this.maximumRetention;
    }

    /**
     * Get the defaultRetention property: The default retention for the Service Tier, in days.
     *
     * @return the defaultRetention value.
     */
    public Long defaultRetention() {
        return this.defaultRetention;
    }

    /**
     * Get the capacityReservationLevel property: The capacity reservation level in GB per day. Returned for the
     * Capacity Reservation Service Tier.
     *
     * @return the capacityReservationLevel value.
     */
    public Long capacityReservationLevel() {
        return this.capacityReservationLevel;
    }

    /**
     * Get the lastSkuUpdate property: Time when the sku was last updated for the workspace. Returned for the Capacity
     * Reservation Service Tier.
     *
     * @return the lastSkuUpdate value.
     */
    public String lastSkuUpdate() {
        return this.lastSkuUpdate;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
