// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.models.LinkedServiceEntityStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The top level Linked service resource container. */
@Fluent
public final class LinkedServiceInner extends ProxyResource {
    /*
     * The properties of the linked service.
     */
    @JsonProperty(value = "properties", required = true)
    private LinkedServiceProperties innerProperties = new LinkedServiceProperties();

    /*
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /**
     * Get the innerProperties property: The properties of the linked service.
     *
     * @return the innerProperties value.
     */
    private LinkedServiceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the LinkedServiceInner object itself.
     */
    public LinkedServiceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the resourceId property: The resource id of the resource that will be linked to the workspace. This should be
     * used for linking resources which require read access.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: The resource id of the resource that will be linked to the workspace. This should be
     * used for linking resources which require read access.
     *
     * @param resourceId the resourceId value to set.
     * @return the LinkedServiceInner object itself.
     */
    public LinkedServiceInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the writeAccessResourceId property: The resource id of the resource that will be linked to the workspace.
     * This should be used for linking resources which require write access.
     *
     * @return the writeAccessResourceId value.
     */
    public String writeAccessResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().writeAccessResourceId();
    }

    /**
     * Set the writeAccessResourceId property: The resource id of the resource that will be linked to the workspace.
     * This should be used for linking resources which require write access.
     *
     * @param writeAccessResourceId the writeAccessResourceId value to set.
     * @return the LinkedServiceInner object itself.
     */
    public LinkedServiceInner withWriteAccessResourceId(String writeAccessResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withWriteAccessResourceId(writeAccessResourceId);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the linked service.
     *
     * @return the provisioningState value.
     */
    public LinkedServiceEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: The provisioning state of the linked service.
     *
     * @param provisioningState the provisioningState value to set.
     * @return the LinkedServiceInner object itself.
     */
    public LinkedServiceInner withProvisioningState(LinkedServiceEntityStatus provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LinkedServiceProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property innerProperties in model LinkedServiceInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceInner.class);
}
