// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.models.AzureResourceProperties;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryPropertiesRelated;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** A Log Analytics QueryPack-Query definition. */
@Fluent
public final class LogAnalyticsQueryPackQueryInner extends AzureResourceProperties {
    /*
     * Properties that define an Log Analytics QueryPack-Query resource.
     */
    @JsonProperty(value = "properties")
    private LogAnalyticsQueryPackQueryProperties innerProperties;

    /**
     * Get the innerProperties property: Properties that define an Log Analytics QueryPack-Query resource.
     *
     * @return the innerProperties value.
     */
    private LogAnalyticsQueryPackQueryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: The unique ID of your application. This field cannot be changed.
     *
     * @return the id value.
     */
    public String idPropertiesId() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Get the displayName property: Unique display name for your query within the Query Pack.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: Unique display name for your query within the Query Pack.
     *
     * @param displayName the displayName value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the timeCreated property: Creation Date for the Log Analytics Query, in ISO 8601 format.
     *
     * @return the timeCreated value.
     */
    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    /**
     * Get the timeModified property: Last modified date of the Log Analytics Query, in ISO 8601 format.
     *
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    /**
     * Get the author property: Object Id of user creating the query.
     *
     * @return the author value.
     */
    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    /**
     * Get the description property: Description of the query.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the query.
     *
     * @param description the description value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the body property: Body of the query.
     *
     * @return the body value.
     */
    public String body() {
        return this.innerProperties() == null ? null : this.innerProperties().body();
    }

    /**
     * Set the body property: Body of the query.
     *
     * @param body the body value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withBody(String body) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withBody(body);
        return this;
    }

    /**
     * Get the related property: The related metadata items for the function.
     *
     * @return the related value.
     */
    public LogAnalyticsQueryPackQueryPropertiesRelated related() {
        return this.innerProperties() == null ? null : this.innerProperties().related();
    }

    /**
     * Set the related property: The related metadata items for the function.
     *
     * @param related the related value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withRelated(LogAnalyticsQueryPackQueryPropertiesRelated related) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withRelated(related);
        return this;
    }

    /**
     * Get the tags property: Tags associated with the query.
     *
     * @return the tags value.
     */
    public Map<String, List<String>> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: Tags associated with the query.
     *
     * @param tags the tags value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withTags(Map<String, List<String>> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the properties property: Additional properties that can be set for the query.
     *
     * @return the properties value.
     */
    public Object properties() {
        return this.innerProperties() == null ? null : this.innerProperties().properties();
    }

    /**
     * Set the properties property: Additional properties that can be set for the query.
     *
     * @param properties the properties value to set.
     * @return the LogAnalyticsQueryPackQueryInner object itself.
     */
    public LogAnalyticsQueryPackQueryInner withProperties(Object properties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogAnalyticsQueryPackQueryProperties();
        }
        this.innerProperties().withProperties(properties);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
