// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Storage insight properties. */
@Fluent
public final class StorageInsightProperties {
    /*
     * The names of the blob containers that the workspace should read
     */
    @JsonProperty(value = "containers")
    private List<String> containers;

    /*
     * The names of the Azure tables that the workspace should read
     */
    @JsonProperty(value = "tables")
    private List<String> tables;

    /*
     * The storage account connection details
     */
    @JsonProperty(value = "storageAccount", required = true)
    private StorageAccount storageAccount;

    /*
     * The status of the storage insight
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private StorageInsightStatus status;

    /**
     * Get the containers property: The names of the blob containers that the workspace should read.
     *
     * @return the containers value.
     */
    public List<String> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: The names of the blob containers that the workspace should read.
     *
     * @param containers the containers value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withContainers(List<String> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the tables property: The names of the Azure tables that the workspace should read.
     *
     * @return the tables value.
     */
    public List<String> tables() {
        return this.tables;
    }

    /**
     * Set the tables property: The names of the Azure tables that the workspace should read.
     *
     * @param tables the tables value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the storageAccount property: The storage account connection details.
     *
     * @return the storageAccount value.
     */
    public StorageAccount storageAccount() {
        return this.storageAccount;
    }

    /**
     * Set the storageAccount property: The storage account connection details.
     *
     * @param storageAccount the storageAccount value to set.
     * @return the StorageInsightProperties object itself.
     */
    public StorageInsightProperties withStorageAccount(StorageAccount storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    /**
     * Get the status property: The status of the storage insight.
     *
     * @return the status value.
     */
    public StorageInsightStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccount() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageAccount in model StorageInsightProperties"));
        } else {
            storageAccount().validate();
        }
        if (status() != null) {
            status().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightProperties.class);
}
