// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.SharedKeysOperationsClient;
import com.azure.resourcemanager.loganalytics.fluent.models.SharedKeysInner;
import com.azure.resourcemanager.loganalytics.models.SharedKeys;
import com.azure.resourcemanager.loganalytics.models.SharedKeysOperations;

public final class SharedKeysOperationsImpl implements SharedKeysOperations {
    private static final ClientLogger LOGGER = new ClientLogger(SharedKeysOperationsImpl.class);

    private final SharedKeysOperationsClient innerClient;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    public SharedKeysOperationsImpl(
        SharedKeysOperationsClient innerClient,
        com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public SharedKeys getSharedKeys(String resourceGroupName, String workspaceName) {
        SharedKeysInner inner = this.serviceClient().getSharedKeys(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SharedKeysImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<SharedKeys> getSharedKeysWithResponse(
        String resourceGroupName, String workspaceName, Context context) {
        Response<SharedKeysInner> inner =
            this.serviceClient().getSharedKeysWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new SharedKeysImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public SharedKeys regenerate(String resourceGroupName, String workspaceName) {
        SharedKeysInner inner = this.serviceClient().regenerate(resourceGroupName, workspaceName);
        if (inner != null) {
            return new SharedKeysImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<SharedKeys> regenerateWithResponse(
        String resourceGroupName, String workspaceName, Context context) {
        Response<SharedKeysInner> inner =
            this.serviceClient().regenerateWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new SharedKeysImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    private SharedKeysOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}
