// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list clusters operation response. */
@Fluent
public final class ClusterListResult {
    /*
     * The link used to get the next page of recommendations.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /*
     * A list of Log Analytics clusters.
     */
    @JsonProperty(value = "value")
    private List<ClusterInner> value;

    /**
     * Get the nextLink property: The link used to get the next page of recommendations.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of recommendations.
     *
     * @param nextLink the nextLink value to set.
     * @return the ClusterListResult object itself.
     */
    public ClusterListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: A list of Log Analytics clusters.
     *
     * @return the value value.
     */
    public List<ClusterInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of Log Analytics clusters.
     *
     * @param value the value value to set.
     * @return the ClusterListResult object itself.
     */
    public ClusterListResult withValue(List<ClusterInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
