// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of OperationStatuses. */
public interface OperationStatuses {
    /**
     * Get the status of a long running azure asynchronous operation.
     *
     * @param location The region name of operation.
     * @param asyncOperationId The operation Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of a long running azure asynchronous operation.
     */
    OperationStatus get(String location, String asyncOperationId);

    /**
     * Get the status of a long running azure asynchronous operation.
     *
     * @param location The region name of operation.
     * @param asyncOperationId The operation Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of a long running azure asynchronous operation along with {@link Response}.
     */
    Response<OperationStatus> getWithResponse(String location, String asyncOperationId, Context context);
}
