// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for StorageInsightState. */
public final class StorageInsightState extends ExpandableStringEnum<StorageInsightState> {
    /** Static value OK for StorageInsightState. */
    public static final StorageInsightState OK = fromString("OK");

    /** Static value ERROR for StorageInsightState. */
    public static final StorageInsightState ERROR = fromString("ERROR");

    /**
     * Creates or finds a StorageInsightState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding StorageInsightState.
     */
    @JsonCreator
    public static StorageInsightState fromString(String name) {
        return fromString(name, StorageInsightState.class);
    }

    /**
     * Gets known StorageInsightState values.
     *
     * @return known StorageInsightState values.
     */
    public static Collection<StorageInsightState> values() {
        return values(StorageInsightState.class);
    }
}
