// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.loganalytics.fluent.models.WorkspaceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list workspaces operation response. */
@Fluent
public final class WorkspaceListResult {
    /*
     * A list of workspaces.
     */
    @JsonProperty(value = "value")
    private List<WorkspaceInner> value;

    /**
     * Get the value property: A list of workspaces.
     *
     * @return the value value.
     */
    public List<WorkspaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workspaces.
     *
     * @param value the value value to set.
     * @return the WorkspaceListResult object itself.
     */
    public WorkspaceListResult withValue(List<WorkspaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
