// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/** Resource collection API of Workspaces. */
public interface Workspaces {
    /**
     * Gets the workspaces in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the workspaces in a subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Workspace> list();

    /**
     * Gets the workspaces in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the workspaces in a subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Workspace> list(Context context);

    /**
     * Gets workspaces in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workspaces in a resource group as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Workspace> listByResourceGroup(String resourceGroupName);

    /**
     * Gets workspaces in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workspaces in a resource group as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Workspace> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same
     * subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace.
     * To remove the workspace completely and release the name, use the force flag.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param force Deletes the workspace without the recovery option. A workspace that was deleted with this flag
     *     cannot be recovered.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String workspaceName, Boolean force);

    /**
     * Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same
     * subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace.
     * To remove the workspace completely and release the name, use the force flag.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String workspaceName);

    /**
     * Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same
     * subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace.
     * To remove the workspace completely and release the name, use the force flag.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param force Deletes the workspace without the recovery option. A workspace that was deleted with this flag
     *     cannot be recovered.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String workspaceName, Boolean force, Context context);

    /**
     * Gets a workspace instance.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a workspace instance.
     */
    Workspace getByResourceGroup(String resourceGroupName, String workspaceName);

    /**
     * Gets a workspace instance.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a workspace instance along with {@link Response}.
     */
    Response<Workspace> getByResourceGroupWithResponse(String resourceGroupName, String workspaceName, Context context);

    /**
     * Gets a workspace instance.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a workspace instance along with {@link Response}.
     */
    Workspace getById(String id);

    /**
     * Gets a workspace instance.
     *
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a workspace instance along with {@link Response}.
     */
    Response<Workspace> getByIdWithResponse(String id, Context context);

    /**
     * Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same
     * subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace.
     * To remove the workspace completely and release the name, use the force flag.
     *
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same
     * subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace.
     * To remove the workspace completely and release the name, use the force flag.
     *
     * @param id the resource ID.
     * @param force Deletes the workspace without the recovery option. A workspace that was deleted with this flag
     *     cannot be recovered.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByIdWithResponse(String id, Boolean force, Context context);

    /**
     * Begins definition for a new Workspace resource.
     *
     * @param name resource name.
     * @return the first stage of the new Workspace definition.
     */
    Workspace.DefinitionStages.Blank define(String name);
}
