/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.loganalytics.fluent.models.ClusterProperties;
import com.azure.resourcemanager.loganalytics.models.AssociatedWorkspace;
import com.azure.resourcemanager.loganalytics.models.BillingType;
import com.azure.resourcemanager.loganalytics.models.CapacityReservationProperties;
import com.azure.resourcemanager.loganalytics.models.ClusterEntityStatus;
import com.azure.resourcemanager.loganalytics.models.ClusterSku;
import com.azure.resourcemanager.loganalytics.models.Identity;
import com.azure.resourcemanager.loganalytics.models.KeyVaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ClusterInner
extends Resource {
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="sku")
    private ClusterSku sku;
    @JsonProperty(value="properties")
    private ClusterProperties innerProperties;

    public Identity identity() {
        return this.identity;
    }

    public ClusterInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ClusterSku sku() {
        return this.sku;
    }

    public ClusterInner withSku(ClusterSku sku) {
        this.sku = sku;
        return this;
    }

    private ClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public ClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public ClusterEntityStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean isDoubleEncryptionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isDoubleEncryptionEnabled();
    }

    public ClusterInner withIsDoubleEncryptionEnabled(Boolean isDoubleEncryptionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withIsDoubleEncryptionEnabled(isDoubleEncryptionEnabled);
        return this;
    }

    public Boolean isAvailabilityZonesEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isAvailabilityZonesEnabled();
    }

    public ClusterInner withIsAvailabilityZonesEnabled(Boolean isAvailabilityZonesEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withIsAvailabilityZonesEnabled(isAvailabilityZonesEnabled);
        return this;
    }

    public BillingType billingType() {
        return this.innerProperties() == null ? null : this.innerProperties().billingType();
    }

    public ClusterInner withBillingType(BillingType billingType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withBillingType(billingType);
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ClusterInner withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public String lastModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDate();
    }

    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    public List<AssociatedWorkspace> associatedWorkspaces() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedWorkspaces();
    }

    public ClusterInner withAssociatedWorkspaces(List<AssociatedWorkspace> associatedWorkspaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withAssociatedWorkspaces(associatedWorkspaces);
        return this;
    }

    public CapacityReservationProperties capacityReservationProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityReservationProperties();
    }

    public ClusterInner withCapacityReservationProperties(CapacityReservationProperties capacityReservationProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterProperties();
        }
        this.innerProperties().withCapacityReservationProperties(capacityReservationProperties);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

