/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class StorageInsightProperties {
    @JsonProperty(value="containers")
    private List<String> containers;
    @JsonProperty(value="tables")
    private List<String> tables;
    @JsonProperty(value="storageAccount", required=true)
    private StorageAccount storageAccount;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private StorageInsightStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(StorageInsightProperties.class);

    public List<String> containers() {
        return this.containers;
    }

    public StorageInsightProperties withContainers(List<String> containers) {
        this.containers = containers;
        return this;
    }

    public List<String> tables() {
        return this.tables;
    }

    public StorageInsightProperties withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    public StorageAccount storageAccount() {
        return this.storageAccount;
    }

    public StorageInsightProperties withStorageAccount(StorageAccount storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    public StorageInsightStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.storageAccount() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageAccount in model StorageInsightProperties"));
        }
        this.storageAccount().validate();
        if (this.status() != null) {
            this.status().validate();
        }
    }
}

