/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.DataSourcesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.DataSourceInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import com.azure.resourcemanager.loganalytics.models.DataSourceListResult;
import reactor.core.publisher.Mono;

public final class DataSourcesClientImpl
implements DataSourcesClient {
    private final DataSourcesService service;
    private final OperationalInsightsManagementClientImpl client;

    DataSourcesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (DataSourcesService)RestProxy.create(DataSourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataSourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName, DataSourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataSourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName, DataSourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataSourceInner> createOrUpdateAsync(String resourceGroupName, String workspaceName, String dataSourceName, DataSourceInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, workspaceName, dataSourceName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataSourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceInner createOrUpdate(String resourceGroupName, String workspaceName, String dataSourceName, DataSourceInner parameters) {
        return (DataSourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, workspaceName, dataSourceName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceInner> createOrUpdateWithResponse(String resourceGroupName, String workspaceName, String dataSourceName, DataSourceInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, workspaceName, dataSourceName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String workspaceName, String dataSourceName) {
        return this.deleteWithResponseAsync(resourceGroupName, workspaceName, dataSourceName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, String dataSourceName) {
        this.deleteAsync(resourceGroupName, workspaceName, dataSourceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String workspaceName, String dataSourceName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, workspaceName, dataSourceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataSourceInner>> getWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataSourceInner>> getWithResponseAsync(String resourceGroupName, String workspaceName, String dataSourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (dataSourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataSourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, workspaceName, dataSourceName, "2020-08-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataSourceInner> getAsync(String resourceGroupName, String workspaceName, String dataSourceName) {
        return this.getWithResponseAsync(resourceGroupName, workspaceName, dataSourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataSourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataSourceInner get(String resourceGroupName, String workspaceName, String dataSourceName) {
        return (DataSourceInner)((Object)this.getAsync(resourceGroupName, workspaceName, dataSourceName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataSourceInner> getWithResponse(String resourceGroupName, String workspaceName, String dataSourceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, workspaceName, dataSourceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataSourceInner>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName, String filter, String skiptoken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspace(this.client.getEndpoint(), resourceGroupName, workspaceName, filter, skiptoken, "2020-08-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceListResult)res.getValue()).value(), ((DataSourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataSourceInner>> listByWorkspaceSinglePageAsync(String resourceGroupName, String workspaceName, String filter, String skiptoken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (workspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workspaceName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByWorkspace(this.client.getEndpoint(), resourceGroupName, workspaceName, filter, skiptoken, "2020-08-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceListResult)res.getValue()).value(), ((DataSourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataSourceInner> listByWorkspaceAsync(String resourceGroupName, String workspaceName, String filter, String skiptoken) {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, filter, skiptoken), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataSourceInner> listByWorkspaceAsync(String resourceGroupName, String workspaceName, String filter) {
        String skiptoken = null;
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, filter, skiptoken), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataSourceInner> listByWorkspaceAsync(String resourceGroupName, String workspaceName, String filter, String skiptoken, Context context) {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(resourceGroupName, workspaceName, filter, skiptoken, context), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceInner> listByWorkspace(String resourceGroupName, String workspaceName, String filter) {
        String skiptoken = null;
        return new PagedIterable(this.listByWorkspaceAsync(resourceGroupName, workspaceName, filter, skiptoken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataSourceInner> listByWorkspace(String resourceGroupName, String workspaceName, String filter, String skiptoken, Context context) {
        return new PagedIterable(this.listByWorkspaceAsync(resourceGroupName, workspaceName, filter, skiptoken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataSourceInner>> listByWorkspaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceListResult)res.getValue()).value(), ((DataSourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataSourceInner>> listByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataSourceListResult)res.getValue()).value(), ((DataSourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    private static interface DataSourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataSourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="workspaceName") String var3, @PathParam(value="dataSourceName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") DataSourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="workspaceName") String var3, @PathParam(value="dataSourceName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataSourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="workspaceName") String var3, @PathParam(value="dataSourceName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataSourceListResult>> listByWorkspace(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="workspaceName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$skiptoken") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataSourceListResult>> listByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

