/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.ManagementGroupsClient;
import com.azure.resourcemanager.loganalytics.fluent.models.ManagementGroupInner;
import com.azure.resourcemanager.loganalytics.implementation.ManagementGroupImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.ManagementGroup;
import com.azure.resourcemanager.loganalytics.models.ManagementGroups;

public final class ManagementGroupsImpl
implements ManagementGroups {
    private static final ClientLogger LOGGER = new ClientLogger(ManagementGroupsImpl.class);
    private final ManagementGroupsClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public ManagementGroupsImpl(ManagementGroupsClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ManagementGroup> list(String resourceGroupName, String workspaceName) {
        PagedIterable<ManagementGroupInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        return Utils.mapPage(inner, inner1 -> new ManagementGroupImpl((ManagementGroupInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ManagementGroup> list(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<ManagementGroupInner> inner = this.serviceClient().list(resourceGroupName, workspaceName, context);
        return Utils.mapPage(inner, inner1 -> new ManagementGroupImpl((ManagementGroupInner)inner1, this.manager()));
    }

    private ManagementGroupsClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}

