/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.loganalytics.fluent.QueriesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.LogAnalyticsQueryPackQueryInner;
import com.azure.resourcemanager.loganalytics.implementation.OperationalInsightsManagementClientImpl;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQueryListResult;
import com.azure.resourcemanager.loganalytics.models.LogAnalyticsQueryPackQuerySearchProperties;
import reactor.core.publisher.Mono;

public final class QueriesClientImpl
implements QueriesClient {
    private final QueriesService service;
    private final OperationalInsightsManagementClientImpl client;

    QueriesClientImpl(OperationalInsightsManagementClientImpl client) {
        this.service = (QueriesService)RestProxy.create(QueriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listSinglePageAsync(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, "2019-09-01", top, includeBody, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listSinglePageAsync(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, "2019-09-01", top, includeBody, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName) {
        Long top = null;
        Boolean includeBody = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> listAsync(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, queryPackName, top, includeBody, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> list(String resourceGroupName, String queryPackName) {
        Long top = null;
        Boolean includeBody = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(resourceGroupName, queryPackName, top, includeBody, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> list(String resourceGroupName, String queryPackName, Long top, Boolean includeBody, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, queryPackName, top, includeBody, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchSinglePageAsync(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (querySearchProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter querySearchProperties is required and cannot be null."));
        }
        querySearchProperties.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.search(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, "2019-09-01", top, includeBody, skipToken, querySearchProperties, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchSinglePageAsync(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (querySearchProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter querySearchProperties is required and cannot be null."));
        }
        querySearchProperties.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.search(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, "2019-09-01", top, includeBody, skipToken, querySearchProperties, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken) {
        return new PagedFlux(() -> this.searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken), nextLink -> this.searchNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties) {
        Long top = null;
        Boolean includeBody = null;
        String skipToken = null;
        return new PagedFlux(() -> this.searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken), nextLink -> this.searchNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LogAnalyticsQueryPackQueryInner> searchAsync(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken, Context context) {
        return new PagedFlux(() -> this.searchSinglePageAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken, context), nextLink -> this.searchNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> search(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties) {
        Long top = null;
        Boolean includeBody = null;
        String skipToken = null;
        return new PagedIterable(this.searchAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LogAnalyticsQueryPackQueryInner> search(String resourceGroupName, String queryPackName, LogAnalyticsQueryPackQuerySearchProperties querySearchProperties, Long top, Boolean includeBody, String skipToken, Context context) {
        return new PagedIterable(this.searchAsync(resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> getWithResponseAsync(String resourceGroupName, String queryPackName, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> getWithResponseAsync(String resourceGroupName, String queryPackName, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> getAsync(String resourceGroupName, String queryPackName, String id) {
        return this.getWithResponseAsync(resourceGroupName, queryPackName, id).flatMap(res -> Mono.justOrEmpty((Object)((LogAnalyticsQueryPackQueryInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner get(String resourceGroupName, String queryPackName, String id) {
        return (LogAnalyticsQueryPackQueryInner)this.getAsync(resourceGroupName, queryPackName, id).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> getWithResponse(String resourceGroupName, String queryPackName, String id, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, queryPackName, id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> putWithResponseAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        }
        queryPayload.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", queryPayload, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> putWithResponseAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        }
        queryPayload.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", queryPayload, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> putAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        return this.putWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload).flatMap(res -> Mono.justOrEmpty((Object)((LogAnalyticsQueryPackQueryInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner put(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        return (LogAnalyticsQueryPackQueryInner)this.putAsync(resourceGroupName, queryPackName, id, queryPayload).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> putWithResponse(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        return (Response)this.putWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> updateWithResponseAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        }
        queryPayload.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", queryPayload, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogAnalyticsQueryPackQueryInner>> updateWithResponseAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (queryPayload == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPayload is required and cannot be null."));
        }
        queryPayload.validate();
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", queryPayload, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LogAnalyticsQueryPackQueryInner> updateAsync(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        return this.updateWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload).flatMap(res -> Mono.justOrEmpty((Object)((LogAnalyticsQueryPackQueryInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogAnalyticsQueryPackQueryInner update(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload) {
        return (LogAnalyticsQueryPackQueryInner)this.updateAsync(resourceGroupName, queryPackName, id, queryPayload).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogAnalyticsQueryPackQueryInner> updateWithResponse(String resourceGroupName, String queryPackName, String id, LogAnalyticsQueryPackQueryInner queryPayload, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, queryPackName, id, queryPayload, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String queryPackName, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String queryPackName, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (queryPackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter queryPackName is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        String apiVersion = "2019-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, queryPackName, id, "2019-09-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String queryPackName, String id) {
        return this.deleteWithResponseAsync(resourceGroupName, queryPackName, id).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String queryPackName, String id) {
        this.deleteAsync(resourceGroupName, queryPackName, id).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String queryPackName, String id, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, queryPackName, id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.searchNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LogAnalyticsQueryPackQueryInner>> searchNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.searchNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).value(), ((LogAnalyticsQueryPackQueryListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="OperationalInsightsM")
    private static interface QueriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Long var6, @QueryParam(value="includeBody") Boolean var7, @QueryParam(value="$skipToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryListResult>> search(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Long var6, @QueryParam(value="includeBody") Boolean var7, @QueryParam(value="$skipToken") String var8, @BodyParam(value="application/json") LogAnalyticsQueryPackQuerySearchProperties var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @PathParam(value="id") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryInner>> put(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @PathParam(value="id") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") LogAnalyticsQueryPackQueryInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @PathParam(value="id") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") LogAnalyticsQueryPackQueryInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="queryPackName") String var4, @PathParam(value="id") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogAnalyticsQueryPackQueryListResult>> searchNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

