/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;
import com.azure.resourcemanager.loganalytics.models.StorageAccount;
import com.azure.resourcemanager.loganalytics.models.StorageInsightStatus;
import java.util.List;
import java.util.Map;

public interface StorageInsight {
    public String id();

    public String name();

    public String type();

    public String etag();

    public Map<String, String> tags();

    public List<String> containers();

    public List<String> tables();

    public StorageAccount storageAccount();

    public StorageInsightStatus status();

    public String resourceGroupName();

    public StorageInsightInner innerModel();

    public Update update();

    public StorageInsight refresh();

    public StorageInsight refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithStorageAccount {
            public Update withStorageAccount(StorageAccount var1);
        }

        public static interface WithTables {
            public Update withTables(List<String> var1);
        }

        public static interface WithContainers {
            public Update withContainers(List<String> var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEtag,
    UpdateStages.WithContainers,
    UpdateStages.WithTables,
    UpdateStages.WithStorageAccount {
        public StorageInsight apply();

        public StorageInsight apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithStorageAccount {
            public WithCreate withStorageAccount(StorageAccount var1);
        }

        public static interface WithTables {
            public WithCreate withTables(List<String> var1);
        }

        public static interface WithContainers {
            public WithCreate withContainers(List<String> var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithContainers,
        WithTables,
        WithStorageAccount {
            public StorageInsight create();

            public StorageInsight create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingWorkspace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

