// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.StorageInsightInner;

/** An instance of this class provides access to all the operations defined in StorageInsightConfigsClient. */
public interface StorageInsightConfigsClient {
    /**
     * Create or update a storage insight.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @param parameters The parameters required to create or update a storage insight.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the top level storage insight resource container along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageInsightInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String workspaceName,
        String storageInsightName,
        StorageInsightInner parameters,
        Context context);

    /**
     * Create or update a storage insight.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @param parameters The parameters required to create or update a storage insight.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the top level storage insight resource container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageInsightInner createOrUpdate(
        String resourceGroupName, String workspaceName, String storageInsightName, StorageInsightInner parameters);

    /**
     * Gets a storage insight instance.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a storage insight instance along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StorageInsightInner> getWithResponse(
        String resourceGroupName, String workspaceName, String storageInsightName, Context context);

    /**
     * Gets a storage insight instance.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a storage insight instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageInsightInner get(String resourceGroupName, String workspaceName, String storageInsightName);

    /**
     * Deletes a storageInsightsConfigs resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName, String workspaceName, String storageInsightName, Context context);

    /**
     * Deletes a storageInsightsConfigs resource.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param storageInsightName Name of the storageInsightsConfigs resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String workspaceName, String storageInsightName);

    /**
     * Lists the storage insight instances within a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list storage insights operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageInsightInner> listByWorkspace(String resourceGroupName, String workspaceName);

    /**
     * Lists the storage insight instances within a workspace.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list storage insights operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StorageInsightInner> listByWorkspace(String resourceGroupName, String workspaceName, Context context);
}
