// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.loganalytics.models.Type;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The top level data export resource container. */
@Fluent
public final class DataExportInner extends ProxyResource {
    /*
     * data export properties.
     */
    @JsonProperty(value = "properties")
    private DataExportProperties innerProperties;

    /** Creates an instance of DataExportInner class. */
    public DataExportInner() {
    }

    /**
     * Get the innerProperties property: data export properties.
     *
     * @return the innerProperties value.
     */
    private DataExportProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the dataExportId property: The data export rule ID.
     *
     * @return the dataExportId value.
     */
    public String dataExportId() {
        return this.innerProperties() == null ? null : this.innerProperties().dataExportId();
    }

    /**
     * Set the dataExportId property: The data export rule ID.
     *
     * @param dataExportId the dataExportId value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withDataExportId(String dataExportId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withDataExportId(dataExportId);
        return this;
    }

    /**
     * Get the tableNames property: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     *
     * @return the tableNames value.
     */
    public List<String> tableNames() {
        return this.innerProperties() == null ? null : this.innerProperties().tableNames();
    }

    /**
     * Set the tableNames property: An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     *
     * @param tableNames the tableNames value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withTableNames(List<String> tableNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withTableNames(tableNames);
        return this;
    }

    /**
     * Get the enable property: Active when enabled.
     *
     * @return the enable value.
     */
    public Boolean enable() {
        return this.innerProperties() == null ? null : this.innerProperties().enable();
    }

    /**
     * Set the enable property: Active when enabled.
     *
     * @param enable the enable value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withEnable(Boolean enable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withEnable(enable);
        return this;
    }

    /**
     * Get the createdDate property: The latest data export rule modification time.
     *
     * @return the createdDate value.
     */
    public String createdDate() {
        return this.innerProperties() == null ? null : this.innerProperties().createdDate();
    }

    /**
     * Set the createdDate property: The latest data export rule modification time.
     *
     * @param createdDate the createdDate value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withCreatedDate(String createdDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withCreatedDate(createdDate);
        return this;
    }

    /**
     * Get the lastModifiedDate property: Date and time when the export was last modified.
     *
     * @return the lastModifiedDate value.
     */
    public String lastModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedDate();
    }

    /**
     * Set the lastModifiedDate property: Date and time when the export was last modified.
     *
     * @param lastModifiedDate the lastModifiedDate value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withLastModifiedDate(String lastModifiedDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withLastModifiedDate(lastModifiedDate);
        return this;
    }

    /**
     * Get the resourceId property: The destination resource ID. This can be copied from the Properties entry of the
     * destination resource in Azure.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: The destination resource ID. This can be copied from the Properties entry of the
     * destination resource in Azure.
     *
     * @param resourceId the resourceId value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the type property: The type of the destination resource.
     *
     * @return the type value.
     */
    public Type typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Get the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when destination is
     * Storage Account.
     *
     * @return the eventHubName value.
     */
    public String eventHubName() {
        return this.innerProperties() == null ? null : this.innerProperties().eventHubName();
    }

    /**
     * Set the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when destination is
     * Storage Account.
     *
     * @param eventHubName the eventHubName value to set.
     * @return the DataExportInner object itself.
     */
    public DataExportInner withEventHubName(String eventHubName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DataExportProperties();
        }
        this.innerProperties().withEventHubName(eventHubName);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
