// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Destination meta data. */
@Fluent
public final class DestinationMetadata {
    /*
     * Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
     */
    @JsonProperty(value = "eventHubName")
    private String eventHubName;

    /** Creates an instance of DestinationMetadata class. */
    public DestinationMetadata() {
    }

    /**
     * Get the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when destination is
     * Storage Account.
     *
     * @return the eventHubName value.
     */
    public String eventHubName() {
        return this.eventHubName;
    }

    /**
     * Set the eventHubName property: Optional. Allows to define an Event Hub name. Not applicable when destination is
     * Storage Account.
     *
     * @param eventHubName the eventHubName value to set.
     * @return the DestinationMetadata object itself.
     */
    public DestinationMetadata withEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
