// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Intelligence Pack containing a string name and boolean indicating if it's enabled. */
@Fluent
public final class IntelligencePackInner {
    /*
     * The name of the intelligence pack.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The enabled boolean for the intelligence pack.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /*
     * The display name of the intelligence pack.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /** Creates an instance of IntelligencePackInner class. */
    public IntelligencePackInner() {
    }

    /**
     * Get the name property: The name of the intelligence pack.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the intelligence pack.
     *
     * @param name the name value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the enabled property: The enabled boolean for the intelligence pack.
     *
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The enabled boolean for the intelligence pack.
     *
     * @param enabled the enabled value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the displayName property: The display name of the intelligence pack.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the intelligence pack.
     *
     * @param displayName the displayName value to set.
     * @return the IntelligencePackInner object itself.
     */
    public IntelligencePackInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
