// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** A management group that is connected to a workspace. */
@Fluent
public final class ManagementGroupInner {
    /*
     * The properties of the management group.
     */
    @JsonProperty(value = "properties")
    private ManagementGroupProperties innerProperties;

    /** Creates an instance of ManagementGroupInner class. */
    public ManagementGroupInner() {
    }

    /**
     * Get the innerProperties property: The properties of the management group.
     *
     * @return the innerProperties value.
     */
    private ManagementGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the serverCount property: The number of servers connected to the management group.
     *
     * @return the serverCount value.
     */
    public Integer serverCount() {
        return this.innerProperties() == null ? null : this.innerProperties().serverCount();
    }

    /**
     * Set the serverCount property: The number of servers connected to the management group.
     *
     * @param serverCount the serverCount value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withServerCount(Integer serverCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withServerCount(serverCount);
        return this;
    }

    /**
     * Get the isGateway property: Gets or sets a value indicating whether the management group is a gateway.
     *
     * @return the isGateway value.
     */
    public Boolean isGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().isGateway();
    }

    /**
     * Set the isGateway property: Gets or sets a value indicating whether the management group is a gateway.
     *
     * @param isGateway the isGateway value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withIsGateway(Boolean isGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withIsGateway(isGateway);
        return this;
    }

    /**
     * Get the name property: The name of the management group.
     *
     * @return the name value.
     */
    public String name() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Set the name property: The name of the management group.
     *
     * @param name the name value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withName(name);
        return this;
    }

    /**
     * Get the id property: The unique ID of the management group.
     *
     * @return the id value.
     */
    public String id() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Set the id property: The unique ID of the management group.
     *
     * @param id the id value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withId(String id) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withId(id);
        return this;
    }

    /**
     * Get the created property: The datetime that the management group was created.
     *
     * @return the created value.
     */
    public OffsetDateTime created() {
        return this.innerProperties() == null ? null : this.innerProperties().created();
    }

    /**
     * Set the created property: The datetime that the management group was created.
     *
     * @param created the created value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withCreated(OffsetDateTime created) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withCreated(created);
        return this;
    }

    /**
     * Get the dataReceived property: The last datetime that the management group received data.
     *
     * @return the dataReceived value.
     */
    public OffsetDateTime dataReceived() {
        return this.innerProperties() == null ? null : this.innerProperties().dataReceived();
    }

    /**
     * Set the dataReceived property: The last datetime that the management group received data.
     *
     * @param dataReceived the dataReceived value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withDataReceived(OffsetDateTime dataReceived) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withDataReceived(dataReceived);
        return this;
    }

    /**
     * Get the version property: The version of System Center that is managing the management group.
     *
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: The version of System Center that is managing the management group.
     *
     * @param version the version value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the sku property: The SKU of System Center that is managing the management group.
     *
     * @return the sku value.
     */
    public String sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    /**
     * Set the sku property: The SKU of System Center that is managing the management group.
     *
     * @param sku the sku value to set.
     * @return the ManagementGroupInner object itself.
     */
    public ManagementGroupInner withSku(String sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementGroupProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
