// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Workspace data table definition. */
@Fluent
public final class TableInner extends ProxyResource {
    /*
     * Table's properties.
     */
    @JsonProperty(value = "properties")
    private TableProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemDataAutoGenerated systemData;

    /** Creates an instance of TableInner class. */
    public TableInner() {
    }

    /**
     * Get the innerProperties property: Table's properties.
     *
     * @return the innerProperties value.
     */
    private TableProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemDataAutoGenerated systemData() {
        return this.systemData;
    }

    /**
     * Get the retentionInDays property: The table retention in days, between 4 and 730. Setting this property to -1
     * will default to the workspace retention.
     *
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDays();
    }

    /**
     * Set the retentionInDays property: The table retention in days, between 4 and 730. Setting this property to -1
     * will default to the workspace retention.
     *
     * @param retentionInDays the retentionInDays value to set.
     * @return the TableInner object itself.
     */
    public TableInner withRetentionInDays(Integer retentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withRetentionInDays(retentionInDays);
        return this;
    }

    /**
     * Get the totalRetentionInDays property: The table total retention in days, between 4 and 2556. Setting this
     * property to -1 will default to table retention.
     *
     * @return the totalRetentionInDays value.
     */
    public Integer totalRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().totalRetentionInDays();
    }

    /**
     * Set the totalRetentionInDays property: The table total retention in days, between 4 and 2556. Setting this
     * property to -1 will default to table retention.
     *
     * @param totalRetentionInDays the totalRetentionInDays value to set.
     * @return the TableInner object itself.
     */
    public TableInner withTotalRetentionInDays(Integer totalRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withTotalRetentionInDays(totalRetentionInDays);
        return this;
    }

    /**
     * Get the archiveRetentionInDays property: The table data archive retention in days. Calculated as
     * (totalRetentionInDays-retentionInDays).
     *
     * @return the archiveRetentionInDays value.
     */
    public Integer archiveRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().archiveRetentionInDays();
    }

    /**
     * Get the searchResults property: Parameters of the search job that initiated this table.
     *
     * @return the searchResults value.
     */
    public SearchResults searchResults() {
        return this.innerProperties() == null ? null : this.innerProperties().searchResults();
    }

    /**
     * Set the searchResults property: Parameters of the search job that initiated this table.
     *
     * @param searchResults the searchResults value to set.
     * @return the TableInner object itself.
     */
    public TableInner withSearchResults(SearchResults searchResults) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withSearchResults(searchResults);
        return this;
    }

    /**
     * Get the restoredLogs property: Parameters of the restore operation that initiated this table.
     *
     * @return the restoredLogs value.
     */
    public RestoredLogs restoredLogs() {
        return this.innerProperties() == null ? null : this.innerProperties().restoredLogs();
    }

    /**
     * Set the restoredLogs property: Parameters of the restore operation that initiated this table.
     *
     * @param restoredLogs the restoredLogs value to set.
     * @return the TableInner object itself.
     */
    public TableInner withRestoredLogs(RestoredLogs restoredLogs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withRestoredLogs(restoredLogs);
        return this;
    }

    /**
     * Get the resultStatistics property: Search job execution statistics.
     *
     * @return the resultStatistics value.
     */
    public ResultStatistics resultStatistics() {
        return this.innerProperties() == null ? null : this.innerProperties().resultStatistics();
    }

    /**
     * Get the plan property: Instruct the system how to handle and charge the logs ingested to this table.
     *
     * @return the plan value.
     */
    public TablePlanEnum plan() {
        return this.innerProperties() == null ? null : this.innerProperties().plan();
    }

    /**
     * Set the plan property: Instruct the system how to handle and charge the logs ingested to this table.
     *
     * @param plan the plan value to set.
     * @return the TableInner object itself.
     */
    public TableInner withPlan(TablePlanEnum plan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withPlan(plan);
        return this;
    }

    /**
     * Get the lastPlanModifiedDate property: The timestamp that table plan was last modified (UTC).
     *
     * @return the lastPlanModifiedDate value.
     */
    public String lastPlanModifiedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().lastPlanModifiedDate();
    }

    /**
     * Get the schema property: Table schema.
     *
     * @return the schema value.
     */
    public Schema schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    /**
     * Set the schema property: Table schema.
     *
     * @param schema the schema value to set.
     * @return the TableInner object itself.
     */
    public TableInner withSchema(Schema schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    /**
     * Get the provisioningState property: Table's current provisioning state. If set to 'updating', indicates a
     * resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is
     * concluded.
     *
     * @return the provisioningState value.
     */
    public ProvisioningStateEnum provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the retentionInDaysAsDefault property: True - Value originates from workspace retention in days, False -
     * Customer specific.
     *
     * @return the retentionInDaysAsDefault value.
     */
    public Boolean retentionInDaysAsDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionInDaysAsDefault();
    }

    /**
     * Get the totalRetentionInDaysAsDefault property: True - Value originates from retention in days, False - Customer
     * specific.
     *
     * @return the totalRetentionInDaysAsDefault value.
     */
    public Boolean totalRetentionInDaysAsDefault() {
        return this.innerProperties() == null ? null : this.innerProperties().totalRetentionInDaysAsDefault();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }
}
