// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.fluent.GatewaysClient;
import com.azure.resourcemanager.loganalytics.models.Gateways;

public final class GatewaysImpl implements Gateways {
    private static final ClientLogger LOGGER = new ClientLogger(GatewaysImpl.class);

    private final GatewaysClient innerClient;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    public GatewaysImpl(
        GatewaysClient innerClient, com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Void> deleteWithResponse(
        String resourceGroupName, String workspaceName, String gatewayId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, workspaceName, gatewayId, context);
    }

    public void delete(String resourceGroupName, String workspaceName, String gatewayId) {
        this.serviceClient().delete(resourceGroupName, workspaceName, gatewayId);
    }

    private GatewaysClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }
}
