// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.loganalytics.fluent.models.TableInner;
import com.azure.resourcemanager.loganalytics.models.ProvisioningStateEnum;
import com.azure.resourcemanager.loganalytics.models.RestoredLogs;
import com.azure.resourcemanager.loganalytics.models.ResultStatistics;
import com.azure.resourcemanager.loganalytics.models.Schema;
import com.azure.resourcemanager.loganalytics.models.SearchResults;
import com.azure.resourcemanager.loganalytics.models.SystemDataAutoGenerated;
import com.azure.resourcemanager.loganalytics.models.Table;
import com.azure.resourcemanager.loganalytics.models.TablePlanEnum;

public final class TableImpl implements Table, Table.Definition, Table.Update {
    private TableInner innerObject;

    private final com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    public Integer retentionInDays() {
        return this.innerModel().retentionInDays();
    }

    public Integer totalRetentionInDays() {
        return this.innerModel().totalRetentionInDays();
    }

    public Integer archiveRetentionInDays() {
        return this.innerModel().archiveRetentionInDays();
    }

    public SearchResults searchResults() {
        return this.innerModel().searchResults();
    }

    public RestoredLogs restoredLogs() {
        return this.innerModel().restoredLogs();
    }

    public ResultStatistics resultStatistics() {
        return this.innerModel().resultStatistics();
    }

    public TablePlanEnum plan() {
        return this.innerModel().plan();
    }

    public String lastPlanModifiedDate() {
        return this.innerModel().lastPlanModifiedDate();
    }

    public Schema schema() {
        return this.innerModel().schema();
    }

    public ProvisioningStateEnum provisioningState() {
        return this.innerModel().provisioningState();
    }

    public Boolean retentionInDaysAsDefault() {
        return this.innerModel().retentionInDaysAsDefault();
    }

    public Boolean totalRetentionInDaysAsDefault() {
        return this.innerModel().totalRetentionInDaysAsDefault();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public TableInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.loganalytics.LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String workspaceName;

    private String tableName;

    public TableImpl withExistingWorkspace(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    public Table create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .createOrUpdate(resourceGroupName, workspaceName, tableName, this.innerModel(), Context.NONE);
        return this;
    }

    public Table create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .createOrUpdate(resourceGroupName, workspaceName, tableName, this.innerModel(), context);
        return this;
    }

    TableImpl(String name, com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerObject = new TableInner();
        this.serviceManager = serviceManager;
        this.tableName = name;
    }

    public TableImpl update() {
        return this;
    }

    public Table apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .update(resourceGroupName, workspaceName, tableName, this.innerModel(), Context.NONE);
        return this;
    }

    public Table apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .update(resourceGroupName, workspaceName, tableName, this.innerModel(), context);
        return this;
    }

    TableImpl(TableInner innerObject, com.azure.resourcemanager.loganalytics.LogAnalyticsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = Utils.getValueFromIdByName(innerObject.id(), "workspaces");
        this.tableName = Utils.getValueFromIdByName(innerObject.id(), "tables");
    }

    public Table refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .getWithResponse(resourceGroupName, workspaceName, tableName, Context.NONE)
                .getValue();
        return this;
    }

    public Table refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getTables()
                .getWithResponse(resourceGroupName, workspaceName, tableName, context)
                .getValue();
        return this;
    }

    public Response<Void> migrateWithResponse(Context context) {
        return serviceManager.tables().migrateWithResponse(resourceGroupName, workspaceName, tableName, context);
    }

    public void migrate() {
        serviceManager.tables().migrate(resourceGroupName, workspaceName, tableName);
    }

    public Response<Void> cancelSearchWithResponse(Context context) {
        return serviceManager.tables().cancelSearchWithResponse(resourceGroupName, workspaceName, tableName, context);
    }

    public void cancelSearch() {
        serviceManager.tables().cancelSearch(resourceGroupName, workspaceName, tableName);
    }

    public TableImpl withRetentionInDays(Integer retentionInDays) {
        this.innerModel().withRetentionInDays(retentionInDays);
        return this;
    }

    public TableImpl withTotalRetentionInDays(Integer totalRetentionInDays) {
        this.innerModel().withTotalRetentionInDays(totalRetentionInDays);
        return this;
    }

    public TableImpl withSearchResults(SearchResults searchResults) {
        this.innerModel().withSearchResults(searchResults);
        return this;
    }

    public TableImpl withRestoredLogs(RestoredLogs restoredLogs) {
        this.innerModel().withRestoredLogs(restoredLogs);
        return this;
    }

    public TableImpl withPlan(TablePlanEnum plan) {
        this.innerModel().withPlan(plan);
        return this;
    }

    public TableImpl withSchema(Schema schema) {
        this.innerModel().withSchema(schema);
        return this;
    }
}
